\   7912WRDS.ASY - Words to link the 7912AD or 7912HB with ASYST
\
\   Copyright (c) 1987, Tektronix, Inc.
\   The program material contained herin is supplied without warranty or
\   representation of any kind.  Tektronix, Inc., assumes no responsibility
\   and shall have no liability, consequential, or otherwise, of any kind
\   arising from the use of this program material or any part thereof.
\
\   Words are designed to support,
\     Tek 7912HB or 7912AD Transient Digitizer
\     Tek 7A29P or 7A16P Programmable Amplifier
\     Tek 7B90P Programmable Timebase
\
\   Here are some examples of using these words
\
\    o  Connect a repetitive signal to the 7912 and adjust for a
\       reasonable display on the video monitor.
\         
\    o  Load ASYST and then Load 7912WRDS.ASY (This file)
\    
\    o  Execute AUTO.INTENSITY to adjust the trace intensity
\    
\    o  Create a waveform array by entering,
\         REAL DIM[ 512 ] ARRAY WFM
\         
\    o  Execute ACQ.ATC to digitize & transfer Avg to Ctr data
\         
\    o  Store the waveform data now on the stack
\         WFM :=
\      
\    o  Display the acquired data
\         WFM Y.AUTO.PLOT
\      
\    o  Execute GET.GND.LEVEL to acquire a ground level, then
\       display the value found.
\         GET.GND.LEVEL
\         GND.LEVEL .
\
\    o  Execute GET.SCALE.FACT to acquire the scale factors, then
\       display them.
\         GET.SCALE.FACT
\         9. 2. SCI.FORMAT   \ Switch notation to see small numbers
\         VOLTS.PER.LEVEL .
\         TIME.PER.POINT .
\         -1. 4. FIX.FORMAT  \ Switch back to Fixed Notation
\
\    o  Apply the ground and scaling information to the waveform
\         WFM GND.LEVEL -
\         2 /                \ Extra factor of 2 from ATC operation
\         VOLTS.PER.LEVEL *
\         WFM :=



\ Set up GPIB communications with 7912AD or 7912HB and
\ programmable plugins (Assumes Primary Address of 3)
\
3 GPIB.DEVICE DIG             \ Digitizer (Tek 7912AD or 7912HB)
0 SECONDARY.ADDRESS
EOI.ON                        \ Terminate on EOI asserted
EOS.OFF                       \ No extra End-of-String character
INTEGER DIM[ 1030 ] ARRAY BIN.DATA  \ Waveform data input buffer
BIN.DATA []GPIB.BUFFER        \ Declare it
BIN.DATA DMA.GPIB.BUFFER      \ Make it available for DMA

3 GPIB.DEVICE AMP             \ Amplifier (Tek 7A16P or 7A29P)
1 SECONDARY.ADDRESS
3 GPIB.DEVICE TB              \ Timebase (Tek 7B90P)
2 SECONDARY.ADDRESS

SEND.INTERFACE.CLEAR          \ Become Controller-In-Charge
REMOTE.ENABLE.ON


\ Digitize and transfer Average to Center waveform and exit
\ with integer waveform data on stack.
\
: ACQ.ATC
   " DIG DAT;ATC;READ ATC" DIG GPIB.WRITE  \ Digitize the data
   ME LISTENER                \ Set up transfer
   DIG TALKER
   DMA.LISTEN                 \ Use DMA for speed
   UNLISTEN                   \ Release GPIB
   UNTALK

   BIN.DATA UNPACK            \ Unpack buffer to integers
   DUP
   SUB[ 4 , 512 , 2 ]         \ Select high bytes
   256 *                      \ Shift them
   SWAP
   SUB[ 5 , 512 , 2 ]         \ Select low bytes
   +                          \ Add them to shifted high bytes
;


\ Auto intensity words.  Strategy is to set a low trace intensity,
\ digitize and read number of vertical values captured.  Intensity is
\ iteratively increased while counting verticals until there are enough
\ to be considered a good trace.

INTEGER SCALAR NVER           \  Number of verticals found

\ This word digitizes data and reads the byte count of the verticals array.
\
: GET.NUM.VER
   " DIG DAT;READ VER" DIG GPIB.WRITE  \ Read verticals array
   ME LISTENER                \ Set up transfer
   DIG TALKER
   STACK.LISTEN DROP          \ Read & discard % header character
   STACK.LISTEN 256 *         \ Shift high byte of byte count
   STACK.LISTEN +             \ Add low byte of byte count
   1 - 2 / NVER :=            \ Store in NVER
   DMA.LISTEN                 \ Quickly read & discard verticals
   UNLISTEN                   \ Release the GPIB
   UNTALK
;

INTEGER SCALAR MAI            \ Main intensity
INTEGER SCALAR INTENS.START   \ Starting value for intensity
INTEGER SCALAR INTENS.INCR    \ Increment for intensity increase
INTEGER SCALAR NVER.MIN       \ Min number of vert values accepted

 250 INTENS.START :=          \ Initialize variables
   2 INTENS.INCR :=
1000 NVER.MIN :=

\ This word iteratively determines a good trace intensity and
\ leaves the digitizer set at that level.
\
: AUTO.INTENSITY
   " MAI 0" DIG GPIB.WRITE    \ Turn off trace
   75 MSEC.DELAY              \ Let target erase
   INTENS.START MAI :=        \ Get a starting intensity
   BEGIN
     MAI INTENS.INCR + DUP MAI :=      \ Increment the intensity
     " MAI" "." "CAT DIG GPIB.WRITE    \ Set it in digitizer
     GET.NUM.VER              \ Digitize & find out how many verticals
     NVER NVER.MIN >          \ Enough?
   UNTIL                      \ Loop until enough trace intensity
;

REAL SCALAR GND.LEVEL         \ Mean ground level
100 STRING "AMP.SETS          \ Buffer for amplifier settings
100 STRING "TB.SETS           \ Buffer for timebase settings

\ Automatic ground reference word.  Assumes programmable plugins.
\ Queries both plugins for settings, grounds amplifier and auto-triggers
\ timebase on line signal.  AUTO.INTENSITY sets trace brightness and
\ ACQ.ATC acquires the ground signal, which is reduced to an average value.
\
: GET.GND.LEVEL
   " SET?" AMP GPIB.WRITE     \ Store amplifier settings
   "AMP.SETS AMP GPIB.READ   
   " SET?" TB GPIB.WRITE      \ Store timebase settings
   "TB.SETS TB GPIB.READ
   " CPL GND" AMP GPIB.WRITE  \ Ground the amplifier input
   " MOD PPA;SRC LIN" TB GPIB.WRITE  \ Auto trig on line signal

   AUTO.INTENSITY             \ Set intensity for a good trace
   ACQ.ATC                    \ Get a ground trace waveform
   MEAN                       \ Find average
   GND.LEVEL :=               \ Store ground level

   "AMP.SETS AMP GPIB.WRITE   \ Restore amplifier settings
   "TB.SETS TB GPIB.WRITE     \ Restore timebase settings
;

40 STRING "TEXT.BUF

\ Word to read and decode a numeric parameter from the digitizer.  Enter
\ with command header on string stack, return with numeric result on number
\ stack.  Can be used to read trace intensity and scale factors.
\
: GET.NUMERIC.PARM
   "DUP                       \ Save a copy of the command header
   " ?" "CAT DIG GPIB.WRITE   \ Append a '?' and send to digitizer
   "TEXT.BUF DIG GPIB.READ    \ Read string result back from dig.
   "TEXT.BUF "SKIP            \ Skip over header part of answer
   ASCII ; "NUMBER            \ Convert numeric string to number
;

REAL SCALAR VOLTS.PER.LEVEL   \ Volts per digitizer level
REAL SCALAR TIME.PER.POINT    \ Sample interval

\ Word to read vertical and horizontal scale factors from
\ digitizer mainframe.  This will work with MANUAL plugins too.
\
: GET.SCALE.FACT
  " VS1" GET.NUMERIC.PARM     \	Read Volts per division
  64 / VOLTS.PER.LEVEL :=     \ 64 levels per div
  " HS1" GET.NUMERIC.PARM     \ Read Time per division
  51.2  / TIME.PER.POINT :=   \ 51.2 samples per div
;


